﻿# -*- coding: UTF-8 -*-
from time import sleep
from constant import CmdConstants
from constant import CLI_CMD_Prompt
import re


def connectCLI(ssh, userName, userPasswd):
    cliRet = ssh.execCmdNoLogTimout("/startup_disk/image/ISM/ism_ap/CLI/ismcli/start.sh -u "+userName+" -ip 127.0.0.1 -port 8080", CmdConstants.TLV_RETRY_INTERVAL_TIME)
    cliRet = ssh.execCmdNoLogTimout(userPasswd, CmdConstants.TLV_RETRY_INTERVAL_TIME)


def execCmd(sshConnector, cmd, logger, userName, userPasswd):
    '''
    Function describe:    Execute CLI command interface.
    Return value:         (boolean, cliRet)    

    Revision History:     1. Created 2014-02-21 
    '''
    
    if not sshConnector or not cmd or not logger:
        logger.error('Parameter invalid when execute CLI command!')
        return (False, None)
    
    ssh = sshConnector.getConnectionNoException()
    connectCLI(ssh, userName, userPasswd)
    
    cliRet = ''
    exceptionTimes = 0
    
    while exceptionTimes < CmdConstants.CLI_EXECMD_RETRY_TIMES: 
        try:
            cliRet = (ssh.execCmdNoLogTimout(cmd, CmdConstants.CLI_DEFAULT_TIMEOUT)).encode("utf-8")
        except:
            logger.error('[cliCmdManager.py]-execute command[' + cmd + '] exception!')
            
            sleep(CmdConstants.CLI_RETRY_INTERVAL_TIME)
            exceptionTimes += 1
            
            logger.warn('Try to get SSH connection again!')
            ssh = sshConnector.getConnectionNoException()
        else:
            if cliRet.strip().endswith(CLI_CMD_Prompt.STORAGE):
                try:
                    ssh.close()
                except:
                    pass
                finally:
                    ssh = sshConnector.getConnectionNoException()
            else:
                return (True, cliRet)
        finally:exitCLI(ssh)
            
    else:
        logger.error('Execute command[' + cmd + '] exception 3 times!')
        return (False, cliRet)
    
    
    
    
def execShellCmd(sshConnector, cmd, logger, userName, userPasswd):
    '''
    Function describe:    Execute CLI command interface.
    Return value:         (boolean, cliRet)    

    Revision History:     1. Created 2014-02-21 
    '''
    
    if not sshConnector or not cmd or not logger:
        logger.error('Parameter invalid when execute CLI command!')
        return (False, None)
    
    ssh = sshConnector.getConnectionNoException()
    shellCmd = "sudo /opt/huawei/snas/script/inspect_mml/CollectG2.sh " + re.escape(userName) + " "  + re.escape(userPasswd) + " " + re.escape(cmd)
    cliRet = ''
    exceptionTimes = 0
    
    while exceptionTimes < CmdConstants.CLI_EXECMD_RETRY_TIMES: 
        try:
            cliRet = (ssh.execCmdNoLogTimout(shellCmd, CmdConstants.CLI_DEFAULT_TIMEOUT)).encode("utf-8")
            cliRet = cliRet.replace(userPasswd, "******")
        except:
            logger.error('[cliCmdManager.py]-execute command exception!')
            
            sleep(CmdConstants.CLI_RETRY_INTERVAL_TIME)
            exceptionTimes += 1
            
            logger.warn('Try to get SSH connection again!')
            ssh = sshConnector.getConnectionNoException()
        else:
            if cliRet.strip().endswith(CLI_CMD_Prompt.STORAGE):
                try:
                    ssh.close()
                except:
                    pass
                finally:
                    ssh = sshConnector.getConnectionNoException()
            else:
                return (True, cliRet)
            
    else:
        logger.error('Execute command[' + cmd + '] exception 3 times!')
        return (False, cliRet)
    
    
    
def exitCLI(ssh):
    cliRet = ssh.execCmdNoLogTimout("exit", CmdConstants.TLV_RETRY_INTERVAL_TIME)
    
